<?php
include('includes/header.php'); 
// The header.php already includes necessary setup and login check.

// Example logic to fetch some stats
$pdo = get_pdo();
$total_users = 0;
$total_pages = 0;

if ($pdo) {
    $total_users = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
    $total_pages = $pdo->query("SELECT COUNT(*) FROM pages")->fetchColumn();
}
?>

<h1 class="mb-4">Dashboard Overview</h1>
<hr>

<div class="row">
    <div class="col-md-4">
        <div class="card text-white bg-primary mb-3">
            <div class="card-header">Total Users</div>
            <div class="card-body">
                <h5 class="card-title display-4"><?= $total_users ?></h5>
                <p class="card-text">Registered users on the platform.</p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card text-white bg-success mb-3">
            <div class="card-header">Total Pages</div>
            <div class="card-body">
                <h5 class="card-title display-4"><?= $total_pages ?></h5>
                <p class="card-text">Static content pages.</p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card text-white bg-warning mb-3">
            <div class="card-header">System Status</div>
            <div class="card-body">
                <h5 class="card-title display-4">OK</h5>
                <p class="card-text">All systems operational.</p>
            </div>
        </div>
    </div>
</div>

<div class="card mt-4">
    <div class="card-header">
        Recent Activity
    </div>
    <div class="card-body">
        <p>No recent activity logs available yet.</p>
    </div>
</div>

<?php include('includes/footer.php'); ?>