<?php
// Function to check if user is logged in
function check_login() {
    if (!isset($_SESSION['user_id'])) {
        header('Location: index.php'); // Redirect to login
        exit;
    }
}

// Function to safely connect to DB (ensures INSTALLED is true)
function get_pdo() {
    if (INSTALLED !== true) {
        header('Location: ../install/step1_welcome.php');
        exit;
    }
    return connect_db(DB_SERVER, DB_USERNAME, DB_PASSWORD, DB_NAME);
}

// Logout function
function logout() {
    session_start();
    $_SESSION = array(); // Clear all session variables
    session_destroy();
    header('Location: index.php');
    exit;
}

// Function to delete a user
function delete_user($user_id) {
    $pdo = get_pdo();
    if ($pdo) {
        // Prevent deleting the currently logged-in user (optional but recommended)
        if ($user_id == $_SESSION['user_id']) {
            return "error: You cannot delete your own account while logged in.";
        }
        
        try {
            // Prepare the SQL statement to delete the user by ID
            $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
            if ($stmt->execute([$user_id])) {
                return "success: User deleted successfully.";
            } else {
                return "error: Failed to execute deletion query.";
            }
        } catch (PDOException $e) {
            // Log the error
            return "error: Database error during deletion.";
        }
    }
    return "error: Database connection failed.";
}
?>