<?php
// admin/menu_reorder.php

include('includes/header.php'); // Ensure this includes the security check and get_pdo()
header('Content-Type: application/json');

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method not allowed.']);
    exit;
}

$pdo = get_pdo();

if (!$pdo) {
    echo json_encode(['status' => 'error', 'message' => 'Database connection failed.']);
    exit;
}

// Get JSON data from the request body
$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

if (!isset($data['order']) || !is_array($data['order']) || empty($data['order']) || !isset($data['menu_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid data provided.']);
    exit;
}

$menu_id = (int)$data['menu_id'];

try {
    // Start transaction for atomic update
    $pdo->beginTransaction();
    
    // Prepare update statement outside the loop
    $stmt = $pdo->prepare("UPDATE menu_items SET order_num = ? WHERE id = ? AND menu_id = ?");

    foreach ($data['order'] as $item) {
        $item_id = (int)$item['id'];
        $order_num = (int)$item['order'];

        // Execute update for each item
        $stmt->execute([$order_num, $item_id, $menu_id]);
    }
    
    $pdo->commit();
    echo json_encode(['status' => 'success', 'message' => 'Menu order updated.']);

} catch (PDOException $e) {
    $pdo->rollBack();
    // Log error for debugging
    error_log("Menu Reorder Error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Database error during reordering.']);
}

exit;
?>