<?php
include('includes/header.php'); // Includes session check and security

$message = '';

// --- Delete Action ---
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $page_id_to_delete = (int)$_GET['id'];
    $pdo = get_pdo();
    
    if ($pdo) {
        try {
            $stmt = $pdo->prepare("DELETE FROM pages WHERE id = ?");
            if ($stmt->execute([$page_id_to_delete])) {
                // Redirect to clean URL after successful deletion
                header('Location: pages.php?status=success&msg=' . urlencode('Page deleted successfully.'));
                exit;
            } else {
                $message = ['type' => 'danger', 'text' => 'Failed to execute deletion query.'];
            }
        } catch (PDOException $e) {
            $message = ['type' => 'danger', 'text' => 'Database error during deletion.'];
        }
    } else {
        $message = ['type' => 'danger', 'text' => 'Database connection failed.'];
    }
}

// Display status message if redirected after action
if (isset($_GET['status']) && isset($_GET['msg'])) {
    $message = ['type' => $_GET['status'], 'text' => htmlspecialchars($_GET['msg'])];
}


// --- READ (Display Page List) ---
$pdo = get_pdo();
$pages = [];
if ($pdo) {
    try {
        $stmt = $pdo->prepare("SELECT id, title, slug, status FROM pages ORDER BY id DESC");
        $stmt->execute();
        $pages = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        $message = ['type' => 'danger', 'text' => 'Error fetching pages: ' . $e->getMessage()];
    }
}
?>

<h1 class="mb-4"><i class="fas fa-file-alt me-2"></i> Page Management</h1>
<hr>

<?php if (!empty($message)): ?>
    <div class="alert alert-<?= $message['type'] ?> alert-dismissible fade show" role="alert">
        <?= $message['text'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<div class="card shadow mb-4">
    <div class="card-header py-3 d-flex justify-content-between align-items-center">
        <h6 class="m-0 font-weight-bold text-primary">All Pages</h6>
        <a href="pages_add.php" class="btn btn-sm btn-primary"><i class="fas fa-plus me-1"></i> Add New Page</a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <?php if ($pages): ?>
                <table class="table table-bordered table-striped" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Title</th>
                            <th>Slug</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($pages as $page): ?>
                        <tr>
                            <td><?= htmlspecialchars($page['id']) ?></td>
                            <td><?= htmlspecialchars($page['title']) ?></td>
                            <td><code>/<?= htmlspecialchars($page['slug']) ?></code></td>
                            <td>
                                <?php if ($page['status'] == 'published'): ?>
                                    <span class="badge bg-success">Published</span>
                                <?php else: ?>
                                    <span class="badge bg-warning">Draft</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="pages_edit.php?id=<?= $page['id'] ?>" class="btn btn-sm btn-info me-2" title="Edit"><i class="fas fa-edit"></i></a>
                                
                                <a href="pages.php?action=delete&id=<?= $page['id'] ?>" 
                                   class="btn btn-sm btn-danger" 
                                   title="Delete"
                                   onclick="return confirm('Are you sure you want to delete page: <?= htmlspecialchars($page['title']) ?>?');">
                                    <i class="fas fa-trash"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <div class="alert alert-info">No pages found in the database.</div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>