<?php
include('includes/header.php'); // Includes session check and database connection

$error = '';
$success = '';
$user_id = $_SESSION['user_id']; 
$pdo = get_pdo();
$user_data = null;

// Fetch the user's current password hash for comparison
if ($pdo) {
    try {
        $stmt = $pdo->prepare("SELECT password FROM users WHERE id = ?");
        $stmt->execute([$user_id]);
        $user_data = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$user_data) {
            $error = 'User data not found.';
            // Safety measure: redirect to logout if user data is missing
            // header('Location: logout.php'); exit; 
        }
    } catch (PDOException $e) {
        $error = 'Database error fetching user details.';
    }
} else {
    $error = 'Database connection failed.';
}


// --- Handle Form Submission ---
if ($_SERVER['REQUEST_METHOD'] == 'POST' && $user_data) {
    $current_password = $_POST['current_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    // --- Validation ---
    if (empty($current_password) || empty($new_password) || empty($confirm_password)) {
        $error = 'All fields are required.';
    } elseif (strlen($new_password) < 6) {
        $error = 'New password must be at least 6 characters long.';
    } elseif ($new_password !== $confirm_password) {
        $error = 'New password and confirmation password do not match.';
    } elseif (!password_verify($current_password, $user_data['password'])) {
        $error = 'Current password is incorrect.';
    } else {
        // --- Update Logic ---
        try {
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);

            $sql = "UPDATE users SET password = ? WHERE id = ?";
            $update_stmt = $pdo->prepare($sql);
            $update_stmt->execute([$hashed_password, $user_id]);

            $success = "Password updated successfully!";
            
            // Clear form fields on success
            $_POST = array(); 

        } catch (PDOException $e) {
            $error = 'Database error updating password: ' . $e->getMessage();
        }
    }
}
?>

<h1 class="mb-4"><i class="fas fa-key me-2"></i> Change Password</h1>
<hr>

<?php if ($success): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= $success ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<?php if ($error): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= $error ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<div class="card shadow mb-4">
    <div class="card-header py-3">
        <h6 class="m-0 font-weight-bold text-primary">Security Settings</h6>
    </div>
    <div class="card-body">
        <form method="POST">
            <div class="mb-3">
                <label for="current_password" class="form-label">Current Password <span class="text-danger">*</span></label>
                <input type="password" class="form-control" id="current_password" name="current_password" required>
            </div>
            <hr>
            <div class="mb-3">
                <label for="new_password" class="form-label">New Password <span class="text-danger">*</span></label>
                <input type="password" class="form-control" id="new_password" name="new_password" required>
                <small class="text-muted">Minimum 6 characters.</small>
            </div>
            <div class="mb-3">
                <label for="confirm_password" class="form-label">Confirm New Password <span class="text-danger">*</span></label>
                <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
            </div>

            <button type="submit" class="btn btn-warning">
                <i class="fas fa-lock me-1"></i> Update Password
            </button>
            <a href="profile.php" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-1"></i> Back to Profile
            </a>
        </form>
    </div>
</div>

<?php include('includes/footer.php'); ?>