<?php
// Note: We include config.php which now has the DB details, but INSTALLED is still false
require_once('../config.php'); 
// Check if DB is configured, if not, redirect back
if (INSTALLED === true) {
    header('Location: ../admin/dashboard.php');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = trim($_POST['username']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];

    if ($password !== $confirm_password) {
        $error = 'Passwords do not match.';
    } elseif (strlen($password) < 6) {
        $error = 'Password must be at least 6 characters long.';
    } else {
        $pdo = connect_db(DB_SERVER, DB_USERNAME, DB_PASSWORD, DB_NAME);

        if ($pdo) {
            try {
                // Hash the password using PHP's recommended method
                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                $role = 'admin';

                // Insert the first admin user
                $stmt = $pdo->prepare("INSERT INTO users (username, email, password, role) VALUES (?, ?, ?, ?)");
                $stmt->execute([$username, $email, $hashed_password, $role]);

                // Update config.php to set INSTALLED to true
                $config_content = file_get_contents('../config.php');
                $config_content = str_replace(
                    "define('INSTALLED', false);",
                    "define('INSTALLED', true);",
                    $config_content
                );
                file_put_contents('../config.php', $config_content);

                // Success! Redirect to completion page
                header('Location: complete.php');
                exit;

            } catch (PDOException $e) {
                // Specifically catch duplicate entry errors for username/email
                if ($e->getCode() == 23000) {
                     $error = 'Username or Email already exists. Please choose a different one.';
                } else {
                     $error = 'An error occurred during admin creation: ' . $e->getMessage();
                }
            }
        } else {
            $error = 'Database connection failed. Please re-run step 2 if config details are wrong.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Step 3: Admin Info Setup</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container my-5">
        <div class="card shadow-lg">
            <div class="card-header bg-primary text-white">
                <h2>Admin Panel Installation Wizard</h2>
            </div>
            <div class="card-body">
                <h3>Step 3: Administrator Account</h3>
                <p>Create your first administrator account to manage the website.</p>
                <?php if ($error): ?>
                    <div class="alert alert-danger"><?= $error ?></div>
                <?php endif; ?>
                <form method="POST">
                    <div class="mb-3">
                        <label for="username" class="form-label">Username</label>
                        <input type="text" class="form-control" id="username" name="username" required>
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">Email</label>
                        <input type="email" class="form-control" id="email" name="email" required>
                    </div>
                    <div class="mb-3">
                        <label for="password" class="form-label">Password</label>
                        <input type="password" class="form-control" id="password" name="password" required>
                    </div>
                    <div class="mb-3">
                        <label for="confirm_password" class="form-label">Confirm Password</label>
                        <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                    </div>
                    <button type="submit" class="btn btn-success btn-lg">Complete Installation</button>
                </form>
            </div>
            <div class="card-footer text-muted">
                Current Step: Admin Account Setup
            </div>
        </div>
    </div>
</body>
</html>