<?php require 'header.php'; require 'sidebar.php'; ?>

<main class="flex-1 pt-16">
    <div class="p-6 lg:p-10">

        <!-- Header -->
        <div class="mb-10">
            <h1 class="text-4xl font-bold text-gray-800">Dashboard</h1>
            <p class="text-lg text-gray-600 mt-2">Welcome back, <?= htmlspecialchars($_SESSION['username']) ?>!</p>
        </div>

        <!-- Stats -->
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-10">
            <?php
            $total_posts = $pdo->query("SELECT COUNT(*) FROM posts")->fetchColumn();
            $today_posts = $pdo->query("SELECT COUNT(*) FROM posts WHERE DATE(created_at)=CURDATE()")->fetchColumn();
            $total_cats = $pdo->query("SELECT COUNT(*) FROM categories")->fetchColumn();
            ?>
            <div class="bg-white rounded-xl shadow p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-500">Total Posts</p>
                        <p class="text-4xl font-bold text-blue-600 mt-2"><?= $total_posts ?></p>
                    </div>
                    <i class="fas fa-file-alt text-5xl text-blue-100"></i>
                </div>
            </div>
            <div class="bg-white rounded-xl shadow p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-500">Today's Posts</p>
                        <p class="text-4xl font-bold text-green-600 mt-2"><?= $today_posts ?></p>
                    </div>
                    <i class="fas fa-calendar-day text-5xl text-green-100"></i>
                </div>
            </div>
            <div class="bg-white rounded-xl shadow p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-500">Categories</p>
                        <p class="text-4xl font-bold text-purple-600 mt-2"><?= $total_cats ?></p>
                    </div>
                    <i class="fas fa-folder-open text-5xl text-purple-100"></i>
                </div>
            </div>
            <div class="bg-white rounded-xl shadow p-6">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-gray-500">Status</p>
                        <p class="text-3xl font-bold text-emerald-600 mt-2">All Good</p>
                    </div>
                    <i class="fas fa-check-circle text-5xl text-emerald-100"></i>
                </div>
            </div>
        </div>

        <!-- Main Content Area -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Left + Center -->
            <div class="lg:col-span-2 space-y-8">
                <!-- Recent Posts -->
                <div class="bg-white rounded-xl shadow">
                    <div class="px-8 py-5 border-b flex justify-between items-center">
                        <h2 class="text-xl font-bold">Recent Posts</h2>
                        <a href="posts.php" class="text-blue-600 hover:underline">View all</a>
                    </div>
                    <div class="divide-y">
                        <?php 
                        $posts = $pdo->query("SELECT * FROM posts ORDER BY created_at DESC LIMIT 8")->fetchAll();
                        foreach($posts as $p): ?>
                        <div class="p-6 hover:bg-gray-50 transition">
                            <a href="add-post.php?id=<?= $p['id'] ?>" class="font-medium text-gray-800 hover:text-blue-600">
                                <?= htmlspecialchars($p['title']) ?>
                            </a>
                            <p class="text-sm text-gray-500 mt-1">
                                <?= date('M j, Y \a\t g:i A', strtotime($p['created_at'])) ?>
                            </p>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <!-- Right Sidebar -->
            <div class="space-y-8">
                <!-- Quick Actions -->
                <div class="bg-white rounded-xl shadow p-6">
                    <h3 class="font-bold text-lg mb-4">Quick Actions</h3>
                    <div class="space-y-3">
                        <a href="add-post.php" class="btn btn-block btn-primary">+ New Post</a>
                        <a href="media.php" class="btn btn-block btn-outline">Upload Media</a>
                    </div>
                </div>

                <!-- Activity -->
                <div class="bg-white rounded-xl shadow p-6">
                    <h3 class="font-bold text-lg mb-4">Recent Activity</h3>
                    <div class="space-y-3 text-sm">
                        <div class="flex items-center space-x-3">
                            <div class="w-8 h-8 bg-blue-100 rounded flex items-center justify-center text-blue-600">
                                <i class="fas fa-plus"></i>
                            </div>
                            <div>
                                <p>Post created: "Hello World"</p>
                                <p class="text-gray-500">2 hours ago</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<script>
    // Mobile menu toggle
    document.getElementById('menuBtn').addEventListener('click', () => {
        document.getElementById('sidebar').classList.toggle('-translate-x-full');
        document.getElementById('overlay').classList.toggle('hidden');
    });
</script>

<?php require 'footer.php'; ?>