<?php
session_start();
if (isset($_SESSION['user_id'])) {
    header("Location: dashboard.php");
    exit;
}

require '../config/database.php';

$error = '';

if ($_POST) {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    if (empty($username) || empty($password)) {
        $error = "Username and password required!";
    } else {
        $stmt = $pdo->prepare("SELECT id, username, password FROM users WHERE username = ?");
        $stmt->execute([$username]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            header("Location: dashboard.php");
            exit;
        } else {
            $error = "Invalid username or password!";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en" class="h-full bg-gray-50">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login • ProCMS</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/daisyui@4.12.10/dist/full.min.css" rel="stylesheet">
    <script src="https://kit.fontawesome.com/7b9b4a83b3.js" crossorigin="anonymous"></script>
</head>
<body class="h-full flex items-center justify-center">

<div class="w-full max-w-md">
    <div class="bg-white rounded-2xl shadow-2xl p-10">

        <!-- Logo -->
        <div class="text-center mb-10">
            <h1 class="text-5xl font-black text-transparent bg-clip-text bg-gradient-to-r from-blue-600 to-purple-600">
                ProCMS
            </h1>
            <p class="text-gray-500 mt-3 text-lg">Welcome back! Please login</p>
        </div>

        <!-- Error Alert -->
        <?php if ($error): ?>
            <div class="alert alert-error shadow-lg mb-6">
                <i class="fas fa-exclamation-triangle"></i>
                <span><?= htmlspecialchars($error) ?></span>
            </div>
        <?php endif; ?>

        <!-- Login Form -->
        <form method="POST" class="space-y-6">
            <div>
                <label class="label">
                    <span class="label-text font-semibold">Username</span>
                </label>
                <input type="text" name="username" value="<?= htmlspecialchars($_POST['username'] ?? '') ?>"
                       class="input input-bordered w-full input-lg" placeholder="admin" required autofocus>
            </div>

            <div>
                <label class="label">
                    <span class="label-text font-semibold">Password</span>
                </label>
                <input type="password" name="password" class="input input-bordered w-full input-lg" 
                       placeholder="••••••••" required>
            </div>

            <div class="flex items-center justify-between">
                <label class="cursor-pointer label">
                    <input type="checkbox" class="checkbox checkbox-primary">
                    <span class="label-text ml-3">Remember me</span>
                </label>
                <a href="#" class="text-sm text-blue-600 hover:underline">Forgot password?</a>
            </div>

            <button type="submit" class="btn btn-primary btn-lg w-full shadow-xl hover:shadow-2xl transform hover:scale-105 transition">
                <i class="fas fa-sign-in-alt mr-3"></i>
                Sign In
            </button>
        </form>

        <!-- Footer -->
        <div class="text-center mt-10 text-sm text-gray-500">
            <p>Default login: <code class="bg-gray-100 px-2 py-1 rounded">admin / admin123</code></p>
            <p class="mt-3">© 2025 ProCMS • All rights reserved</p>
        </div>

    </div>
</div>

</body>
</html>