<?php include 'header.php'; include 'sidebar.php'; ?>

<?php
// Delete post
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $pdo->prepare("DELETE FROM posts WHERE id = ?")->execute([$id]);
    echo "<script>alert('Post deleted successfully!'); window.location='posts.php';</script>";
    exit();
}
?>

<div class="flex-1 p-10 overflow-y-auto">
    <!-- Page Header -->
    <div class="flex flex-col sm:flex-row sm:justify-between sm:items-center mb-10">
        <h1 class="text-4xl font-extrabold text-base-content">All Posts</h1>
        <a href="add-post.php" class="btn btn-primary btn-lg mt-4 sm:mt-0 shadow-lg">
            <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4H4"></path>
            </svg>
            Add New Post
        </a>
    </div>

    <!-- Posts Table -->
    <div class="bg-base-200 rounded-2xl shadow-xl overflow-hidden">
        <div class="overflow-x-auto">
            <table class="table table-zebra w-full">
                <thead class="bg-base-300 text-base-content">
                    <tr>
                        <th class="w-16">#</th>
                        <th>Title</th>
                        <th class="hidden sm:table-cell">Date</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $stmt = $pdo->query("SELECT * FROM posts ORDER BY created_at DESC");
                    $no = 1;
                    if ($stmt->rowCount() == 0):
                    ?>
                    <tr>
                        <td colspan="4" class="text-center py-12 text-gray-500">
                            No posts found. <a href="add-post.php" class="link link-primary">Create your first post</a>
                        </td>
                    </tr>
                    <?php
                    else:
                        while ($post = $stmt->fetch(PDO::FETCH_ASSOC)):
                    ?>
                    <tr class="hover:bg-base-100 transition">
                        <td class="font-bold"><?= $no++ ?></td>
                        <td class="font-medium max-w-xs truncate">
                            <?= htmlspecialchars($post['title']) ?>
                        </td>
                        <td class="hidden sm:table-cell text-sm opacity-80">
                            <?= date('M d, Y - h:i A', strtotime($post['created_at'])) ?>
                        </td>
                        <td class="text-center space-x-2">
                            <a href="add-post.php?id=<?= $post['id'] ?>" 
                               class="btn btn-sm btn-info tooltip" data-tip="Edit">
                                Edit
                            </a>
                            <a href="?delete=<?= $post['id'] ?>" 
                               class="btn btn-sm btn-error tooltip" data-tip="Delete"
                               onclick="return confirm('Are you sure you want to delete this post?')">
                                Delete
                            </a>
                        </td>
                    </tr>
                    <?php 
                        endwhile;
                    endif; 
                    ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Empty State (যদি কোনো পোস্ট না থাকে) -->
    <?php if ($stmt->rowCount() > 0 && $no == 1): ?>
    <div class="text-center py-20">
        <h3 class="text-2xl font-bold mb-4">No posts yet!</h3>
        <a href="add-post.php" class="btn btn-primary btn-lg">Create Your First Post</a>
    </div>
    <?php endif; ?>
</div>

<?php include 'footer.php'; ?>