<?php require 'header.php'; require 'sidebar.php'; ?>

<main class="flex-1 lg:ml-64 pt-16 min-h-screen bg-gray-50">
    <div class="p-6 lg:p-10">

        <div class="max-w-4xl mx-auto">

            <!-- Page Header -->
            <div class="bg-white rounded-2xl shadow-xl shadow-xl p-8 mb-8">
                <h1 class="text-4xl font-black text-gray-800 mb-4">Settings</h1>
                <p class="text-gray-600">Manage your site preferences and configuration.</p>
            </div>

            <?php
            // Save Settings
            if ($_POST) {
                $site_name = trim($_POST['site_name']);
                $site_tagline = trim($_POST['site_tagline']);
                $admin_email = trim($_POST['admin_email']);
                $posts_per_page = (int)$_POST['posts_per_page'];

                $settings = [
                    'site_name' => $site_name,
                    'site_tagline' => $site_tagline,
                    'admin_email' => $admin_email,
                    'posts_per_page' => $posts_per_page
                ];

                file_put_contents('../config/settings.json', json_encode($settings, JSON_PRETTY_PRINT));
                echo '<div class="alert alert-success shadow-lg mb-8">Settings saved successfully!</div>';
            }

            Load current settings
            $config_file = '../config/settings.json';
            $current = file_exists($config_file) ? json_decode(file_get_contents($config_file), true) : [];
            ?>

            <form method="POST" class="space-y-8">

                <!-- General Settings -->
                <div class="bg-white rounded-2xl shadow-xl p-8">
                    <h2 class="text-2xl font-bold text-gray-800 mb-6 flex items-center">
                        <i class="fas fa-cog mr-3 text-blue-600"></i>
                        General Settings
                    </h2>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="label">
                                <span class="label-text font-semibold">Site Title</span>
                            </label>
                            <input type="text" name="site_name" value="<?= htmlspecialchars($current['site_name'] ?? 'ProCMS') ?>"
                                   class="input input-bordered w-full" required>
                        </div>

                        <div>
                            <label class="label">
                                <span class="label-text font-semibold">Tagline</span>
                            </label>
                            <input type="text" name="site_tagline" value="<?= htmlspecialchars($current['site_tagline'] ?? 'Just another ProCMS site') ?>"
                                   class="input input-bordered w-full" placeholder=">
                        </div>

                        <div>
                            <label class="label">
                                <span class="label-text font-semibold">Admin Email</span>
                            </label>
                            <input type="email" name="admin_email" value="<?= htmlspecialchars($current['admin_email'] ?? 'admin@yoursite.com') ?>"
                                   class="input input-bordered w-full" required>
                        </div>

                        <div>
                            <label class="label">
                                <span class="label-text font-semibold">Posts per page</span>
                            </label>
                            <input type="number" name="posts_per_page" value="<?= $current['posts_per_page'] ?? 10 ?>"
                                   min="1" max="50" class="input input-bordered w-full">
                        </div>
                    </div>
                </div>

                <!-- SEO & Social -->
                <div class="bg-white rounded-2xl shadow-xl p-8">
                    <h2 class="text-2xl font-bold text-gray-800 mb-6 flex items-center">
                        <i class="fas fa-search-dollar mr-3 text-green-600"></i>
                        SEO & Social
                    </h2>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="label"><span class="label-text font-semibold">Meta Description</span></label>
                            <textarea name="meta_description" rows="3" class="textarea textarea-bordered w-full"
                                      placeholder="Short description for search engines"><?= htmlspecialchars($current['meta_description'] ?? '') ?></textarea>
                        </div>
                        <div>
                            <label class="label"><span class="label-text font-semibold">Facebook Page URL</span></label>
                            <input type="url" name="facebook" value="<?= htmlspecialchars($current['facebook'] ?? '') ?>"
                                   class="input input-bordered w-full" placeholder="https://facebook.com/yourpage">
                        </div>
                    </div>
                </div>

                <!-- Maintenance Mode -->
                <div class="bg-white rounded-2xl shadow-xl p-8">
                    <h2 class="text-2xl font-bold text-gray-800 mb-6 flex items-center">
                        <i class="fas fa-tools mr-3 text-orange-600"></i>
                        Maintenance Mode
                    </h2>
                    <label class="cursor-pointer label justify-start space-x-4">
                        <input type="checkbox" name="maintenance" <?= ($current['maintenance'] ?? false) ? 'checked' : '' ?> class="toggle toggle-lg toggle-primary">
                        <span class="label-text text-lg">Enable Maintenance Mode</span>
                    </label>
                    <p class="text-sm text-gray-500 mt-3">When enabled, only admin can access the site.</p>
                </div>

                <!-- Save Button -->
                <div class="text-center">
                    <button type="submit" class="btn btn-success btn-lg px-16 shadow-xl hover:shadow-2xl transform hover:scale-105 transition">
                        <i class="fas fa-save mr-3"></i>
                        Save All Settings
                    </button>
                </div>

            </form>

        </div>
    </div>
</main>

<?php require 'footer.php'; ?>