<?php require 'header.php'; require 'sidebar.php'; ?>

<?php
$upload_dir = '../assets/uploads/';
$web_path = '../assets/uploads/';

if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);

// Upload Handler
if (isset($_FILES['file'])) {
    $file = $_FILES['file'];
    $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
    $allowed = ['jpg','jpeg','png','gif','webp','svg','pdf','mp4','mp3','zip'];
    
    if (in_array($ext, $allowed) && $file['size'] < 15000000) { // 15MB
        $name = 'media_' . time() . '_' . rand(1000,9999) . '.' . $ext;
        $path = $upload_dir . $name;
        if (move_uploaded_file($file['tmp_name'], $path)) {
            echo json_encode(['success' => true, 'file' => $web_path . $name]);
        }
    }
    exit;
}

// Delete
if (isset($_GET['delete'])) {
    $file = $upload_dir . basename($_GET['delete']);
    if (file_exists($file)) unlink($file);
    header("Location: media.php" . (isset($_GET['search']) ? '?search='.$_GET['search'] : ''));
    exit;
}

// Search & Filter
$search = trim($_GET['search'] ?? '');
$type_filter = $_GET['type'] ?? 'all';

$files = array_diff(scandir($upload_dir), ['.', '..']);
$filtered_files = [];

foreach ($files as $file) {
    $fullpath = $upload_dir . $file;
    $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
    
    // Search by name
    if ($search && stripos($file, $search) === false) continue;
    
    // Filter by type
    if ($type_filter !== 'all') {
        if ($type_filter === 'image' && !in_array($ext, ['jpg','jpeg','png','gif','webp','svg'])) continue;
        if ($type_filter === 'video' && !in_array($ext, ['mp4','webm','ogg'])) continue;
        if ($type_filter === 'document' && !in_array($ext, ['pdf','doc','docx','txt'])) continue;
    }
    
    $filtered_files[] = [
        'name' => $file,
        'path' => $web_path . $file,
        'size' => filesize($fullpath),
        'ext' => $ext,
        'date' => filemtime($fullpath)
    ];
}

// Sort by date (newest first)
usort($filtered_files, fn($a,$b) => $b['date'] - $a['date']);
?>

<main class="flex-1 lg:ml-64 pt-16 min-h-screen bg-gray-50">
    <div class="p-6 lg:p-10 max-w-7xl mx-auto">

        <h1 class="text-4xl font-black text-gray-800 mb-2">Media Library</h1>
        <p class="text-gray-600 mb-8">Total files: <strong><?= count($filtered_files) ?></strong></p>

        <!-- Search & Filter Bar -->
        <div class="bg-white rounded-2xl shadow-lg p-6 mb-8">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div class="md:col-span-2">
                    <form method="GET">
                        <div class="flex">
                            <input type="text" name="search" value="<?= htmlspecialchars($search) ?>" 
                                   placeholder="Search files by name..." 
                                   class="input input-bordered w-full rounded-r-none">
                            <button type="submit" class="btn btn-primary rounded-l-none">
                                Search
                            </button>
                        </div>
                    </form>
                </div>
                <div>
                    <select onchange="window.location='?type='+this.value+'<?= $search?'&search='.urlencode($search):'' ?>'" 
                            class="select select-bordered w-full">
                        <option value="all" <?= $type_filter=='all'?'selected':'' ?>>All Types</option>
                        <option value="image" <?= $type_filter=='image'?'selected':'' ?>>Images</option>
                        <option value="video" <?= $type_filter=='video'?'selected':'' ?>>Videos</option>
                        <option value="document" <?= $type_filter=='document'?'selected':'' ?>>Documents</option>
                    </select>
                </div>
            </div>
        </div>

        <!-- Upload Area -->
        <div class="bg-white rounded-2xl shadow-xl p-8 mb-8 border-2 border-dashed border-gray-300 hover:border-blue-500 transition cursor-pointer"
             onclick="document.getElementById('fileInput').click()">
            <div class="text-center">
                <i class="fas fa-cloud-upload-alt text-6xl text-gray-400 mb-4"></i>
                <p class="text-xl text-gray-700 font-medium">Click or drop files here to upload</p>
                <p class="text-sm text-gray-500 mt-2">Max 15MB • Images, Videos, PDFs, etc.</p>
            </div>
            <input type="file" id="fileInput" multiple class="hidden" accept="image/*,video/*,.pdf,.doc,.docx">
            <div id="uploadProgress" class="mt-6 hidden">
                <progress class="progress progress-primary w-full" value="0" max="100"></progress>
                <p class="text-center mt-2 text-sm" id="uploadText">Uploading...</p>
            </div>
        </div>

        <!-- Media Grid -->
        <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 xl:grid-cols-8 gap-6">
            <?php if (empty($filtered_files)): ?>
                <div class="col-span-full text-center py-20">
                    <i class="fas fa-images text-8xl text-gray-300 mb-6"></i>
                    <p class="text-2xl text-gray-500">No files found</p>
                </div>
            <?php else: foreach($filtered_files as $f): 
                $is_image = in_array($f['ext'], ['jpg','jpeg','png','gif','webp','svg']);
            ?>
            <div class="bg-white rounded-xl shadow-lg overflow-hidden hover:shadow-2xl transition group relative">
                <?php if ($is_image): ?>
                    <img src="<?= $f['path'] ?>" class="w-full h-40 object-cover">
                <?php else: ?>
                    <div class="w-full h-40 bg-gradient-to-br from-gray-100 to-gray-200 flex items-center justify-center">
                        <i class="fas fa-file-<?= $f['ext']=='pdf'?'pdf':($f['ext']=='mp4'?'video':'alt') ?> text-5xl text-gray-400"></i>
                    </div>
                <?php endif; ?>

                <div class="p-3">
                    <p class="text-xs font-medium truncate" title="<?= $f['name'] ?>"><?= $f['name'] ?></p>
                    <p class="text-xs text-gray-500 mt-1">
                        <?= number_format($f['size']/1024, 1) ?> KB • <?= strtoupper($f['ext']) ?>
                    </p>
                </div>

                <!-- Hover Actions -->
                <div class="absolute inset-0 bg-black bg-opacity-70 opacity-0 group-hover:opacity-100 transition flex items-center justify-center space-x-4">
                    <button onclick="copyURL('<?= $f['path'] ?>')" 
                            class="bg-white text-gray-800 px-4 py-2 rounded-lg hover:bg-gray-100 transition">
                        Copy URL
                    </button>
                    <a href="?delete=<?= urlencode($f['name']) ?><?= $search?'&search='.urlencode($search):'' ?><?= $type_filter!='all'?'&type='.$type_filter:'' ?>" 
                       onclick="return confirm('Delete permanently?')"
                       class="bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 transition">
                        Delete
                    </a>
                </div>
            </div>
            <?php endforeach; endif; ?>
        </div>

    </div>
</main>

<script>
function copyURL(url) {
    navigator.clipboard.writeText(url);
    alert('URL copied: ' + url);
}

// Upload with progress
document.getElementById('fileInput').addEventListener('change', function(e) {
    const files = e.target.files;
    const prog = document.getElementById('uploadProgress');
    const bar = prog.querySelector('progress');
    const text = document.getElementById('uploadText');

    Array.from(files).forEach(file => {
        const fd = new FormData();
        fd.append('file', file);

        prog.classList.remove('hidden');
        const xhr = new XMLHttpRequest();

        xhr.upload.onprogress = function(e) {
            if (e.lengthComputable) {
                const percent = (e.loaded / e.total) * 100;
                bar.value = percent;
                text.textContent = `Uploading ${file.name}... ${Math.round(percent)}%`;
            }
        };

        xhr.onload = () => {
            if (xhr.status === 200) {
                location.reload();
            }
        };

        xhr.open('POST', 'media.php');
        xhr.send(fd);
    });
});
</script>

<?php require 'footer.php'; ?>