<?php
session_start();
if (isset($_SESSION['user_id'])) {
    header("Location: ../admin/dashboard.php");
    exit;
}

require '../../config/database.php';
$error = $success = '';

if ($_POST) {
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone']);
    $pass = $_POST['password'];
    $confirm = $_POST['confirm'];

    if ($pass !== $confirm) {
        $error = "Passwords don't match!";
    } elseif (strlen($pass) < 6) {
        $error = "Password minimum 6 characters!";
    } else {
        $check = $pdo->prepare("SELECT id FROM users WHERE email=? OR phone=?");
        $check->execute([$email, $phone]);
        if ($check->rowCount() > 0) {
            $error = "Email or Phone already used!";
        } else {
            $hash = password_hash($pass, PASSWORD_DEFAULT);
            $pdo->prepare("INSERT INTO users (username, email, phone, password) VALUES (?,?,?,?)")
                ->execute([$name, $email, $phone, $hash]);
            $success = "Registered! Now you can login.";
        }
    }
}
?>

<!DOCTYPE html>
<html class="h-full bg-gradient-to-br from-purple-50 to-blue-50">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register • ProCMS</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/npm/daisyui@4.12.10/dist/full.min.css" rel="stylesheet">
</head>
<body class="h-full flex items-center justify-center p-4">

<div class="w-full max-w-md bg-white/95 backdrop-blur-xl rounded-rounded-3xl shadow-2xl p-10">
    <div class="text-center mb-10">
        <h1 class="text-5xl font-black bg-gradient-to-r from-purple-600 to-blue-600 bg-clip-text text-transparent">ProCMS</h1>
        <p class="mt-4 text-gray-600">Create your account</p>
    </div>

    <?php if($success): ?>
        <div class="alert alert-success mb-6"><?= $success ?></div>
    <?php endif; ?>
    <?php if($error): ?>
        <div class="alert alert-error mb-6"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="POST" class="space-y-6">
        <input type="text" name="name" placeholder="Full Name" class="input input-lg w-full rounded-2xl" required>
        <input type="email" name="email" placeholder="Email" class="input input-lg w-full rounded-2xl" required>
        <input type="tel" name="phone" placeholder="Phone (optional)" class="input input-lg w-full rounded-2xl">
        <input type="password" name="password" placeholder="Password" class="input input-lg w-full rounded-2xl" minlength="6" required>
        <input type="password" name="confirm" placeholder="Confirm Password" class="input input-lg w-full rounded-2xl" required>

        <button type="submit" class="btn btn-primary btn-lg w-full rounded-2xl">
            Create Account
        </button>
    </form>

    <p class="text-center mt-8 text-sm text-gray-600">
        Have account? <a href="login.php" class="text-purple-600 font-bold">Login</a>
    </p>
</div>

</body>
</html>