<?php require 'header.php'; require 'sidebar.php'; ?>

<?php
// ===== ADD CATEGORY =====
if (isset($_POST['add_category'])) {
    $name = trim($_POST['name']);
    $parent_id = (int)$_POST['parent_id'];
    
    if (empty($name)) {
        $error = "Name is required!";
    } else {
        $slug = strtolower(preg_replace('/[^a-z0-9]+/', '-', $name));
        $level = $parent_id > 0 ? 
            $pdo->query("SELECT level FROM categories WHERE id=$parent_id")->fetchColumn() + 1 : 0;
        
        try {
            {
            $stmt = $pdo->prepare("INSERT INTO categories (name, slug, parent_id, level) VALUES (?,?,?,?)");
            $stmt->execute([$name, $slug, $parent_id, $level]);
            $success = "Category added!";
        } catch(Exception $e) {
            $error = "Slug already exists!";
        }
    }
}

// ===== EDIT CATEGORY =====
if (isset($_POST['edit_category'])) {
    $id = (int)$_POST['id'];
    $name = trim($_POST['name']);
    $parent_id = (int)$_POST['parent_id'];
    $slug = strtolower(preg_replace('/[^a-z0-9]+/', '-', $name));
    
    $level = $parent_id > 0 ? 
        $pdo->query("SELECT level FROM categories WHERE id=$parent_id")->fetchColumn() + 1 : 0;
    
    $pdo->prepare("UPDATE categories SET name=?, slug=?, parent_id=?, level=? WHERE id=?")
         ->execute([$name, $slug, $parent_id, $level, $id]);
    $success = "Updated!";
}

// ===== DELETE CATEGORY =====
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $has_child = $pdo->query("SELECT 1 FROM categories WHERE parent_id=$id LIMIT 1")->rowCount();
    $has_post  = $pdo->query("SELECT 1 FROM posts WHERE category_id=$id LIMIT 1")->rowCount();
    
    if ($has_child == 0 && $has_post == 0) {
        $pdo->prepare("DELETE FROM categories WHERE id=?")->execute([$id]);
        $success = "Deleted!";
    } else {
        $error = "Cannot delete – has sub-categories or posts!";
    }
    header("Location: categories.php");
    exit;
}

// ===== GET ALL CATEGORIES FOR SELECT =====
$flat = $pdo->query("SELECT id, name, parent_id, level FROM categories ORDER BY name")->fetchAll();

// ===== BUILD HIERARCHICAL TREE =====
function buildTree($pdo, $parent_id = 0) {
    $tree = [];
    $stmt = $pdo->prepare("
        SELECT c.*, COUNT(p.id) as post_count 
        FROM categories c 
        LEFT JOIN posts p ON c.id = p.category_id 
        WHERE c.parent_id = ? 
        GROUP BY c.id 
        ORDER BY c.name
    ");
    $stmt->execute([$parent_id]);
    
    while ($row = $stmt->fetch()) {
        $row['children'] = buildTree($pdo, $row['id']);
        $tree[] = $row;
    }
    return $tree;
}
$categories_tree = buildTree($pdo);
?>

<main class="flex-1 lg:ml-64 pt-16 min-h-screen bg-gray-50">
    <div class="p-6 lg:p-10 max-w-6xl mx-auto">

        <h1 class="text-4xl font-black text-gray-800 mb-2">Categories</h1>
        <p class="text-gray-600 mb-8">Parent → Child hierarchy supported</p>

        <?php if (isset($error)): ?>
            <div class="alert alert-error shadow-lg mb-6"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        <?php if (isset($success)): ?>
            <div class="alert alert-success shadow-lg mb-6"><?= $success ?></div>
        <?php endif; ?>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">

            <!-- Add Form -->
            <div class="bg-white rounded-2xl shadow-xl p-8">
                <h2 class="text-2xl font-bold mb-6">Add New Category</h2>
                <form method="POST" class="space-y-6">
                    <input type="hidden" name="add_category" value="1">
                    <input type="text" name="name" placeholder="Category Name" class="input input-bordered w-full" required>
                    
                    <select name="parent_id" class="select select-bordered w-full">
                        <option value="0">No Parent (Top Level)</option>
                        <?php foreach($flat as $c): ?>
                            <option value="<?= $c['id'] ?>">
                                <?= str_repeat('— ', $c['level']) ?><?= htmlspecialchars($c['name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    
                    <button type="submit" class="btn btn-success w-full">Add Category</button>
                </form>
            </div>

            <!-- Tree View -->
            <div class="bg-white rounded-2xl shadow-xl overflow-hidden">
                <div class="px-8 py-6 bg-gradient-to-r from-indigo-600 to-purple-600 text-white">
                    <h2 class="text-2xl font-bold">Category Tree</h2>
                </div>
                <div class="p-6 max-h-96 overflow-y-auto">
                    <?php if (empty($categories_tree)): ?>
                        <p class="text-center text-gray-500 py-12">No categories yet</p>
                    <?php else: ?>
                        <ul class="space-y-3">
                            <?php
                            function showTree($cats, $is_last_in_level = []) {
                                $total = count($cats);
                                foreach($cats as $index => $cat):
                                    $is_last = ($index === $total - 1);
                                    $prefix = '';
                                    foreach($is_last_in_level as $lvl => $last) {
                                        $prefix .= $last ? '&nbsp;&nbsp;&nbsp;&nbsp;' : '│&nbsp;&nbsp;&nbsp;';
                                    }
                                    }
                                    $prefix .= $is_last ? '└─ ' : '├─ ';
                                    ?>
                                    <li class="flex items-center justify-between py-3 px-4 bg-gray-50 rounded-lg hover:bg-gray-100">
                                        <span>
                                            <?= $prefix ?><strong><?= htmlspecialchars($cat['name']) ?></strong>
                                            <span class="ml-3 text-xs badge badge-outline"><?= $cat['post_count'] ?> posts</span>
                                        </span>
                                        <span class="space-x-2">
                                            <button onclick='edit(<?= $cat['id'] ?>,"<?= addslashes($cat['name']) ?>",<?= $cat['parent_id'] ?>)' 
                                                    class="btn btn-xs btn-info">Edit</button>
                                            <a href="?delete=<?= $cat['id'] ?>" 
                                               onclick="return confirm('Sure?')" 
                                               class="btn btn-xs btn-error">Del</a>
                                        </span>
                                    </li>
                                    <?php if (!empty($cat['children'])): ?>
                                        <?php 
                                        $new_last = $is_last_in_level;
                                        $new_last[$cat['level']] = $is_last;
                                        showTree($cat['children'], $new_last);
                                        ?>
                                    <?php endif; ?>
                                <?php endforeach;
                            }
                            showTree($categories_tree, []);
                            ?>
                        </ul>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</main>

<!-- Edit Modal -->
<dialog id="editModal" class="modal">
    <div class="modal-box">
        <h3 class="font-bold text-2xl mb-6">Edit Category</h3>
        <form method="POST">
            <input type="hidden" name="edit_category" value="1">
            <input type="hidden" name="id" id="eid">
            <input type="text" name="name" id="ename" class="input input-bordered w-full mb-4" required>
            <select name="parent_id" id="eparent" class="select select-bordered w-full">
                <option value="0">No Parent</option>
                <?php foreach($flat as $c): ?>
                    <option value="<?= $c['id'] ?>"><?= str_repeat('— ', $c['level']) ?><?= htmlspecialchars($c['name']) ?></option>
                <?php endforeach; ?>
            </select>
            <div class="modal-action">
                <button type="submit" class="btn btn-primary">Update</button>
                <button type="button" class="btn" onclick="document.getElementById('editModal').close()">Cancel</button>
            </div>
        </form>
    </div>
</dialog>

<script>
function edit(id, name, parent) {
    document.getElementById('eid').value = id;
    document.getElementById('ename').value = name;
    document.getElementById('eparent').value = parent;
    document.getElementById('editModal').showModal();
}
</script>

<?php require 'footer.php'; ?>