<?php 
require 'header.php'; 
require 'sidebar.php'; 

// Handle Delete
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $del_id = (int)$_GET['delete'];
    if ($del_id != $_SESSION['user_id']) {
        $pdo->prepare("DELETE FROM users WHERE id = ?")->execute([$del_id]);
        echo '<script>alert("User deleted!"); location="users.php";</script>';
        exit;
    }
}

// Handle Add User
if (isset($_POST['add_user'])) {
    $username = trim($_POST['username']);
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);

    $check = $pdo->prepare("SELECT id FROM users WHERE username = ?");
    $check->execute([$username]);
    if ($check->rowCount() > 0) {
        $error = "Username already exists!";
    } else {
        $pdo->prepare("INSERT INTO users (username, password) VALUES (?,?)")
             ->execute([$username, $password]);
        echo '<script>alert("User added successfully!"); location="users.php";</script>';
        exit;
    }
}

// Handle Change Password
if (isset($_POST['change_pass'])) {
    $uid = (int)$_POST['user_id'];
    $newpass = password_hash($_POST['new_password'], PASSWORD_DEFAULT);
    $pdo->prepare("UPDATE users SET password = ? WHERE id = ?")
         ->execute([$newpass, $uid]);
    echo '<script>alert("Password changed!"); location="users.php";</script>';
    exit;
}

// Get all users
$users = $pdo->query("SELECT * FROM users ORDER BY id DESC")->fetchAll();
?>

<main class="flex-1 lg:ml-64 pt-16 min-h-screen bg-gray-50">
    <div class="p-6 lg:p-10 max-w-5xl mx-auto">

        <h1 class="text-4xl font-black text-gray-800 mb-2">User Management</h1>
        <p class="text-gray-600 mb-8">Add, edit or remove admin users</p>

        <?php if (isset($error)): ?>
            <div class="alert alert-error shadow-lg mb-6"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <div class="bg-white rounded-2xl shadow-xl overflow-hidden">
            <div class="p-6 border-b bg-gray-50 flex justify-between items-center">
                <h2 class="text-xl font-bold">All Users</h2>
                <button class="btn btn-success" onclick="document.getElementById('addModal').showModal()">
                    Add New User
                </button>
            </div>

            <div class="overflow-x-auto">
                <table class="table w-full">
                    <thead>
                        <tr class="bg-gray-50">
                            <th class="p-6 text-left">ID</th>
                            <th class="p-6 text-left">Username</th>
                            <th class="p-6 text-left">Joined</th>
                            <th class="p-6 text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($users as $u): ?>
                        <tr class="hover:bg-gray-50">
                            <td class="p-6">#<?= $u['id'] ?></td>
                            <td class="p-6">
                                <div class="flex items-center space-x-3">
                                    <div class="w-10 h-10 bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center text-white font-bold">
                                        <?= strtoupper(substr($u['username'],0,1)) ?>
                                    </div>
                                    <div>
                                        <p class="font-semibold"><?= htmlspecialchars($u['username']) ?></p>
                                    </div>
                                </div>
                            </td>
                            <td class="p-6 text-gray-600">
                                <?= date('M j, Y', strtotime($u['created_at'])) ?>
                            </td>
                            <td class="p-6 text-center space-x-2">
                                <button onclick="openEdit(<?= $u['id'] ?>)" 
                                        class="btn btn-sm btn-info">
                                    Change Password
                                </button>
                                <?php if ($u['id'] != $_SESSION['user_id']): ?>
                                <a href="?delete=<?= $u['id'] ?>" 
                                   onclick="return confirm('Delete this user?')"
                                   class="btn btn-sm btn-error">
                                    Delete
                                </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- Add User Modal -->
<dialog id="addModal" class="modal">
    <div class="modal-box">
        <h3 class="font-bold text-xl mb-6">Add New User</h3>
        <form method="POST">
            <input type="hidden" name="add_user" value="1">
            <div class="space-y-4">
                <input type="text" name="username" placeholder="Username" class="input input-bordered w-full" required>
                <input type="password" name="password" placeholder="Password (min 6 chars)" class="input input-bordered w-full" minlength="6" required>
            </div>
            <div class="modal-action">
                <button type="submit" class="btn btn-success">Create</button>
                <button type="button" class="btn" onclick="document.getElementById('addModal').close()">Cancel</button>
            </div>
        </form>
    </div>
</dialog>

<!-- Edit Password Modal -->
<dialog id="editModal" class="modal">
    <div class="modal-box">
        <h3 class="font-bold text-xl mb-6">Change Password</h3>
        <form method="POST">
            <input type="hidden" name="user_id" id="edit_id">
            <input type="hidden" name="change_pass" value="1">
            <input type="password" name="new_password" placeholder="New password" class="input input-bordered w-full mb-4" minlength="6" required>
            <div class="modal-action">
                <button type="submit" class="btn btn-primary">Update</button>
                <button type="button" class="btn" onclick="document.getElementById('editModal').close()">Cancel</button>
            </div>
        </form>
    </div>
</dialog>

<script>
function openEdit(id) {
    document.getElementById('edit_id').value = id;
    document.getElementById('editModal').showModal();
}
</script>

<?php require 'footer.php'; ?>